
function AISMN_AttackUntilDead::OnEnter(%this, %data)
{
   %object = GetThisObject(%data);
   %object.playThread(0, "attack");
   StartEffect(%object, "combat");
   
	%target = GetParameterTarget(%data);
	if (%target != 0)
	{
	   StartAttackLoop(GetThisObject(%data), %target);
	   
	   //Mount a weapon on the person.
	   //Get the combat component
      %component = slgQueryInterface(GetThisObject(%data), $CID_COMBAT);
      if(0 == %component)
         return;
         
      //Mount the weapons
      %weapon = %component.getDatablock().weaponL;
      if (strlen(%weapon) > 0)
      {
         GetThisObject(%data).mountImage(%weapon, 1);
      }
      
      %weapon = %component.getDatablock().weaponR;
      if (strlen(%weapon) > 0)
      {
         GetThisObject(%data).mountImage(%weapon, 2);
      }
	}
   else
   {
      SetStateVariable(%data, 0, 1.0);
   }
}

function AISMN_AttackUntilDead::OnExit(%this, %data)
{
   %object = GetThisObject(%data);
   
   %object.unmountImage(1);
   %object.unmountImage(2);
	EndAttackLoop(%object, GetStringVariable(%data, "playmusic"));
	
	%object.StopThread(0);
   StopEffect(%object, "combat");
	%object.playThread(0, "root");
}

function AISMN_AttackUntilDead::Update(%this, %data)
{
   // if you have died, stop the fighting state machine
   %object = GetThisObject(%data);
   if (IsAlive(%object) == false)
   {
      SetStringVariable(%data, "playmusic", true);
      ReturnValue(%data, 1);
      return;
   }
   
	//Is the target dead? If so, abort the state machine.
	%target = GetParameterTarget(%data);
	if (IsAlive(%target) == false)
	{
	   SetStringVariable(%data, "playmusic", true);
		ReturnValue(%data, 1);
		return;
	}

	//If I am within attack range, stop.
	if (IsWithinAttackRange(%data, %target) == false)
	{
	   // really want time in state
	   if (TimeInNode(%data) >= 1.5)
	   {
	      SetStringVariable(%data, "playmusic", false);
   		ReturnValue(%data, 0);
   		return;
	   }
	}
	
	FaceObject(%data, %target);
	ReturnValue(%data, -1);
}
